/*------------------------------------------------------------------------------*
 * File Name: AccessWorksheetObjectsTutorial.C									*
 * Creation: GJL 8/15/03														*
 * Purpose: Origin C file containing AccessWorksheetObjectsTutorial example.	*
 * Copyright (c) OriginLab Corp.	2003										*
 * All Rights Reserved															*
 *------------------------------------------------------------------------------*/

#include <Origin.h> // Includes most Origin C header files (including NAG)

/**
		Demonstrate accessing worksheet related internal Origin Objects. This function assumes
		the active window is a worksheet having two columns A and B.
	Return:
		Returns TRUE on successful exit and FALSE on error.
*/
BOOL AccessWorksheetObjectsTutorial()
{
	PageBase 		pb;                                // Declare PageBase object
	WorksheetPage 	wp;                           // Declare WorksheetPage object
	Worksheet 		wks;                              // Declare Worksheet (Layer) object
	Column 			col;                                 // Declare Column object
	DataRange 		dr;								  //Declare DataRange object
	
	string 	strWindowName, strColName;
	int 	iPageType, iColNum;

	// Note: The Project object is an instance of the Project class that is automatically available
	// to all Origin C functions
	
	// *** Use Project class Pages collection to get active Page (must use PageBase not Page or ***
	// *** WorksheetPage - don't assume type of active window)                            ***
	pb = Project.Pages();                       // Use no argument to get active PageBase
	if( !pb.IsValid() )                         // If not found (not valid) return error
		return FALSE;
	
	// *** Get window name and check page type of found PageBase object ***
	strWindowName = pb.GetName();               // Get page (window) name
	iPageType = pb.GetType();                   // Get page (window) type 
	if( iPageType != EXIST_WKS )                // Origin C page types (EXIST_x) in OC_const.h
		return FALSE;                           // If not worksheet (2) return error
	
	// *** Explicit cast of PageBase object to WorksheetPage object, OK because we know it ***
	// *** is a worksheet window (see above)                                               ***
	wp = (WorksheetPage) pb;                    // Cast PageBase to WorksheetPage because PageBase does not have collection of Layers
	if( !wp.IsValid() )                         // If not valid cast return error
		return FALSE;	

	// *** Use WorksheetPage class Layers collection to get Worksheet (Layer) ***
	wks = (Worksheet) wp.Layers(0);              // Get Worksheet (Layer) object (WorksheetPage allow has multiple layers - index is 0 based)
	if( !wks.IsValid() )                         // If not found return error
		return FALSE;

	// *** Use Worksheet class Columns collection to get second column and check column name ***
	iColNum = 1;                                 // Init to 1, refers to second column
	col = wks.Columns(iColNum);                  // Get second column in worksheet (0 based index)
	if( !col.IsValid() )                         // If not valid column return error
		return FALSE;
	strColName = col.GetName();                  // Get column name to check (just for fun)
	
	// *** Use Worksheet class Columns collection to get column A and then check column index ***
	col = wks.Columns("A");                      // Re-use same column object to get Column A
	if( !col.IsValid() )                         // If not valid column return error
		return FALSE;
	iColNum = col.GetIndex();                    // Get column index to check (just for fun)
	
	dr.Add("X", wks, 0, 0, -1, 0);				//add X Column as subrange 1
	dr.Add("Y", wks, 0, 1, -1, 1);				//add Y Column as subrange 2
	
	//get data from datarange
	vector vX, vY;	
    dr.GetData(&vX, 0);
    dr.GetData(&vY, 1);    
	
    //reset data to datarange
	vY = vX * 2;
	dr.SetData(&vY, &vX);
	
	// *** Add a new Layer, and copy the Worksheet 1 Data to Worksheet 2***
	//add a new layer
	int nIndex = wp.AddLayer();
	wks = (Worksheet) wp.Layers(nIndex);
	
	//reset datarange
	dr.Reset();
	
	dr.Add("X", wks, 0, 0, -1, 0);				//add X Column as subrange 1
	dr.Add("Y", wks, 0, 1, -1, 1);				//add Y Column as subrange 2
	dr.SetData(&vY, &vX);
    
	
	return TRUE;                                 // Done!
}